/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize
#define iMouse AUTO_MOUSE

/////////////////////////////////////////////////////////////////////////////////

// Simple "Automatic Mouse". Simulates scanning the mouse over the full range of
// the screen with the X and Y scanning frequencies being different. TheEmu.

#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
#define MOUSE_POS   vec2((1.0+cos(iGlobalTime*MOUSE_SPEED))*u_WindowSize/2.0)
#define MOUSE_PRESS vec2(0.0,0.0)
#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )

/////////////////////////////////////////////////////////////////////////////////

// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.

vec2 cinv( vec2 z)  { float d = dot(z,z); return vec2( z.x, -z.y ) / d; }

void main( void )
{
	vec2 p = 1.2*(-iResolution.xy+2.0*gl_FragCoord.xy)/iResolution.y;

	vec2 z = p;
	float f = 4.;
	float g = 4.;
	if(p.x>.1){
		p = 1.2*(-iResolution.xy+2.0*iMouse.xy)/iResolution.y;
		z.x-= 1.5;
		z*=1.5;
	}
	
	for( int i=0; i<128; i++ ) 
	{
		
		z=cinv(z+p)+z-p;
		f = min( f, abs(dot(z-p,z-p) ));
		g = min( g, dot(z+p,z+p));
	}
	
	f = 1.0+log(f)/15.0;
	g = 1.0+log(g)/10.0;


	gl_FragColor = 1.-g*abs(vec4(g,f*g,f*f,1.0));
}